/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.base.asm;

import com.google.common.annotations.VisibleForTesting;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.StaticComponentInitializer;
import dev.onyxstudios.cca.internal.base.LazyDispatcher;
import dev.onyxstudios.cca.internal.base.asm.CcaAsmHelper;
import dev.onyxstudios.cca.internal.base.asm.StaticComponentLoadingException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public final class CcaBootstrap
extends LazyDispatcher {
    public static final String COMPONENT_TYPE_INIT_DESC = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getObjectType((String)CcaAsmHelper.IDENTIFIER), Type.getType(Class.class)});
    public static final String COMPONENT_TYPE_GET0_DESC = "(L" + CcaAsmHelper.COMPONENT_CONTAINER + ";)L" + CcaAsmHelper.COMPONENT + ";";
    public static final String STATIC_INIT_ENTRYPOINT = "cardinal-components:static-init";
    public static final CcaBootstrap INSTANCE = new CcaBootstrap();
    private final List<EntrypointContainer<StaticComponentInitializer>> staticComponentInitializers = FabricLoader.getInstance().getEntrypointContainers("cardinal-components:static-init", StaticComponentInitializer.class);
    @VisibleForTesting
    Collection<class_2960> additionalComponentIds = new ArrayList<class_2960>();
    private Map<class_2960, Class<? extends ComponentKey<?>>> generatedComponentTypes = new HashMap();

    public CcaBootstrap() {
        super("registering a ComponentType");
    }

    public boolean isGenerated(Class<?> keyClass) {
        if (this.requiresInitialization()) {
            return false;
        }
        return this.generatedComponentTypes.containsValue(keyClass);
    }

    @Nullable
    public Class<? extends ComponentKey<?>> getGeneratedComponentTypeClass(class_2960 componentId) {
        this.ensureInitialized();
        assert (this.generatedComponentTypes != null);
        return this.generatedComponentTypes.get(componentId);
    }

    @Override
    protected void init() {
        try {
            TreeSet<class_2960> staticComponentTypes = new TreeSet<class_2960>(Comparator.comparing(class_2960::toString));
            for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
                ModMetadata metadata = modContainer.getMetadata();
                if (!metadata.containsCustomValue("cardinal-components")) continue;
                try {
                    for (CustomValue value : metadata.getCustomValue("cardinal-components").getAsArray()) {
                        staticComponentTypes.add(new class_2960(value.getAsString()));
                    }
                }
                catch (ClassCastException | class_151 e) {
                    throw new StaticComponentLoadingException("Failed to load component ids declared by " + metadata.getName() + "(" + metadata.getId() + ")", e);
                }
            }
            for (EntrypointContainer entrypointContainer : this.staticComponentInitializers) {
                try {
                    staticComponentTypes.addAll(((StaticComponentInitializer)entrypointContainer.getEntrypoint()).getSupportedComponentKeys());
                }
                catch (Throwable e) {
                    ModMetadata badMod = entrypointContainer.getProvider().getMetadata();
                    throw new StaticComponentLoadingException(String.format("Exception while querying %s (%s) for supported static component types", badMod.getName(), badMod.getId()), e);
                }
            }
            staticComponentTypes.addAll(this.additionalComponentIds);
            this.spinStaticContainerItf(staticComponentTypes);
            this.generatedComponentTypes = this.spinStaticComponentKeys(staticComponentTypes);
        }
        catch (IOException | UncheckedIOException e) {
            throw new StaticComponentLoadingException("Failed to load statically defined components", e);
        }
    }

    @Override
    protected void postInit() {
        for (EntrypointContainer<StaticComponentInitializer> staticInitializer : this.staticComponentInitializers) {
            ((StaticComponentInitializer)staticInitializer.getEntrypoint()).finalizeStaticBootstrap();
        }
    }

    private Map<class_2960, Class<? extends ComponentKey<?>>> spinStaticComponentKeys(Set<class_2960> staticComponentKeys) throws IOException {
        HashMap generatedComponentTypes = new HashMap(staticComponentKeys.size());
        for (class_2960 componentId : staticComponentKeys) {
            ClassNode componentTypeWriter = new ClassNode(393216);
            String componentTypeName = CcaAsmHelper.getComponentTypeName(componentId);
            componentTypeWriter.visit(52, 17, componentTypeName, null, CcaAsmHelper.COMPONENT_TYPE, null);
            MethodVisitor init = componentTypeWriter.visitMethod(1, "<init>", COMPONENT_TYPE_INIT_DESC, null, null);
            init.visitCode();
            init.visitVarInsn(25, 0);
            init.visitVarInsn(25, 1);
            init.visitVarInsn(25, 2);
            init.visitMethodInsn(183, CcaAsmHelper.COMPONENT_TYPE, "<init>", COMPONENT_TYPE_INIT_DESC, false);
            init.visitInsn(177);
            init.visitEnd();
            MethodVisitor get = componentTypeWriter.visitMethod(4, "getInternal", COMPONENT_TYPE_GET0_DESC, null, null);
            get.visitCode();
            get.visitVarInsn(25, 1);
            get.visitTypeInsn(192, "dev/onyxstudios/cca/_generated_/GeneratedComponentContainer");
            get.visitMethodInsn(182, "dev/onyxstudios/cca/_generated_/GeneratedComponentContainer", CcaAsmHelper.getStaticStorageGetterName(componentId), CcaAsmHelper.STATIC_CONTAINER_GETTER_DESC, false);
            get.visitInsn(176);
            get.visitEnd();
            Class<?> ct = CcaAsmHelper.generateClass(componentTypeWriter);
            generatedComponentTypes.put(componentId, ct);
        }
        return generatedComponentTypes;
    }

    private void spinStaticContainerItf(Set<class_2960> staticComponentTypes) throws IOException {
        ClassNode staticContainerWriter = new ClassNode(393216);
        staticContainerWriter.visit(52, 1025, "dev/onyxstudios/cca/_generated_/GeneratedComponentContainer", null, CcaAsmHelper.DYNAMIC_COMPONENT_CONTAINER_IMPL, null);
        MethodVisitor init = staticContainerWriter.visitMethod(1, "<init>", CcaAsmHelper.ABSTRACT_COMPONENT_CONTAINER_CTOR_DESC, null, null);
        init.visitCode();
        init.visitVarInsn(25, 0);
        init.visitMethodInsn(183, CcaAsmHelper.DYNAMIC_COMPONENT_CONTAINER_IMPL, "<init>", CcaAsmHelper.ABSTRACT_COMPONENT_CONTAINER_CTOR_DESC, false);
        init.visitInsn(177);
        init.visitEnd();
        for (class_2960 componentId : staticComponentTypes) {
            MethodVisitor methodWriter = staticContainerWriter.visitMethod(1, CcaAsmHelper.getStaticStorageGetterName(componentId), CcaAsmHelper.STATIC_CONTAINER_GETTER_DESC, null, null);
            methodWriter.visitInsn(1);
            methodWriter.visitInsn(176);
            methodWriter.visitEnd();
        }
        staticContainerWriter.visitEnd();
        CcaAsmHelper.generateClass(staticContainerWriter);
    }
}

